/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Borland.Eco.Handles;
using Borland.Eco.Windows.Forms;
using Borland.Eco.WinForm;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.UmlRt;
using Borland.Eco.Services;
using Borland.Eco.AutoContainers;

namespace Borland.Eco.Diagnostics
{
	/// <summary>
	/// Summary description for EcoWinForm.
	/// </summary>
	public class UndoDebuggerPanel: System.Windows.Forms.Form, IEcoSpaceDebuggerPanel
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.Panel panel1;
		private Borland.Eco.Handles.ReferenceHandle rhRoot;
		private System.Windows.Forms.Button btnRefresh;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.ListBox lbxUndoblocks;
		private System.Windows.Forms.ListBox lbxRedoblocks;
		private System.Windows.Forms.Button btnMoveSelectedUndoUp;
		private System.Windows.Forms.Button btnMoveSelectedUndoDown;
		private System.Windows.Forms.Button btnUndoLatest;
		private System.Windows.Forms.Button btnRedoLatest;
		private System.Windows.Forms.Button btnSetCheckPoint;
		private System.Windows.Forms.Button btnNamedCheckPoint;
		private System.Windows.Forms.TextBox tbxUndoName;
		private System.Windows.Forms.Button btnUndoSelected;
		private System.Windows.Forms.Button btnClearEmpty;
		private System.Windows.Forms.Button btnCommitTransaction;
		private System.Windows.Forms.Button btnRollbackTransaction;
		private System.Windows.Forms.Button btnStartTransaction;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.GroupBox groupBox3;
		private System.Windows.Forms.GroupBox groupBox4;
		private System.Windows.Forms.GroupBox groupBox5;
		private System.Windows.Forms.Timer timer1;
		private System.Windows.Forms.ListBox listBox2;
		private Borland.Eco.Handles.ReferenceHandle referenceHandle1;
		private Borland.Eco.WinForm.EcoActionExtender ecoActionExtender1;
		private Borland.Eco.WinForm.EcoAutoFormExtender ecoAutoFormExtender1;
		private Borland.Eco.WinForm.EcoDragDropExtender ecoDragDropExtender1;
		private System.Windows.Forms.Label label1;

		public UndoDebuggerPanel()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}
		#region Services
		public IPersistenceService PersistenceService
		{
			get	{ return (IPersistenceService)EcoSpace.GetEcoService(typeof(IPersistenceService)); }
		}
		public IDirtyListService DirtyListService
		{
			get { return (IDirtyListService)EcoSpace.GetEcoService(typeof(IDirtyListService)); }
		}

		public IUndoService UndoService
		{
			get { return (IUndoService)EcoSpace.GetEcoService(typeof(IUndoService)); }
		}

		public ITypeSystemService TypeSystemService
		{
			get	{ return (ITypeSystemService)EcoSpace.GetEcoService(typeof(ITypeSystemService)); }
		}
		public IOclService OclService
		{
			get { return (IOclService)EcoSpace.GetEcoService(typeof(IOclService)); }
		}
		public IObjectFactoryService ObjectFactoryService
		{
			get	{ return (IObjectFactoryService)EcoSpace.GetEcoService(typeof(IObjectFactoryService)); }
		}
		public IVariableFactoryService VariableFactoryService
		{
			get { return (IVariableFactoryService)EcoSpace.GetEcoService(typeof(IVariableFactoryService)); }
		}
		public IExtentService ExtentService
		{
			get { return (IExtentService)EcoSpace.GetEcoService(typeof(IExtentService)); }
		}
		#endregion

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(UndoDebuggerPanel));
			Borland.Eco.Handles.OclColumn oclColumn11 = new Borland.Eco.Handles.OclColumn();
			this.panel1 = new System.Windows.Forms.Panel();
			this.groupBox5 = new System.Windows.Forms.GroupBox();
			this.btnRedoLatest = new System.Windows.Forms.Button();
			this.btnUndoLatest = new System.Windows.Forms.Button();
			this.btnClearEmpty = new System.Windows.Forms.Button();
			this.groupBox4 = new System.Windows.Forms.GroupBox();
			this.btnNamedCheckPoint = new System.Windows.Forms.Button();
			this.tbxUndoName = new System.Windows.Forms.TextBox();
			this.btnSetCheckPoint = new System.Windows.Forms.Button();
			this.groupBox3 = new System.Windows.Forms.GroupBox();
			this.lbxRedoblocks = new System.Windows.Forms.ListBox();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.label1 = new System.Windows.Forms.Label();
			this.btnUndoSelected = new System.Windows.Forms.Button();
			this.lbxUndoblocks = new System.Windows.Forms.ListBox();
			this.btnRefresh = new System.Windows.Forms.Button();
			this.btnMoveSelectedUndoUp = new System.Windows.Forms.Button();
			this.btnMoveSelectedUndoDown = new System.Windows.Forms.Button();
			this.listBox2 = new System.Windows.Forms.ListBox();
			this.referenceHandle1 = new Borland.Eco.Handles.ReferenceHandle();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.btnStartTransaction = new System.Windows.Forms.Button();
			this.btnRollbackTransaction = new System.Windows.Forms.Button();
			this.btnCommitTransaction = new System.Windows.Forms.Button();
			this.rhRoot = new Borland.Eco.Handles.ReferenceHandle();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.timer1 = new System.Windows.Forms.Timer(this.components);
			this.ecoActionExtender1 = new Borland.Eco.WinForm.EcoActionExtender();
			this.ecoAutoFormExtender1 = new Borland.Eco.WinForm.EcoAutoFormExtender();
			this.ecoDragDropExtender1 = new Borland.Eco.WinForm.EcoDragDropExtender();
			this.panel1.SuspendLayout();
			this.groupBox5.SuspendLayout();
			this.groupBox4.SuspendLayout();
			this.groupBox3.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// panel1
			// 
			this.panel1.AccessibleDescription = resources.GetString("panel1.AccessibleDescription");
			this.panel1.AccessibleName = resources.GetString("panel1.AccessibleName");
			this.panel1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("panel1.Anchor")));
			this.panel1.AutoScroll = ((bool)(resources.GetObject("panel1.AutoScroll")));
			this.panel1.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("panel1.AutoScrollMargin")));
			this.panel1.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("panel1.AutoScrollMinSize")));
			this.panel1.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("panel1.BackgroundImage")));
			this.panel1.Controls.Add(this.groupBox5);
			this.panel1.Controls.Add(this.groupBox4);
			this.panel1.Controls.Add(this.groupBox3);
			this.panel1.Controls.Add(this.groupBox2);
			this.panel1.Controls.Add(this.groupBox1);
			this.panel1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("panel1.Dock")));
			this.panel1.Enabled = ((bool)(resources.GetObject("panel1.Enabled")));
			this.panel1.Font = ((System.Drawing.Font)(resources.GetObject("panel1.Font")));
			this.panel1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("panel1.ImeMode")));
			this.panel1.Location = ((System.Drawing.Point)(resources.GetObject("panel1.Location")));
			this.panel1.Name = "panel1";
			this.panel1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("panel1.RightToLeft")));
			this.panel1.Size = ((System.Drawing.Size)(resources.GetObject("panel1.Size")));
			this.panel1.TabIndex = ((int)(resources.GetObject("panel1.TabIndex")));
			this.panel1.Text = resources.GetString("panel1.Text");
			this.panel1.Visible = ((bool)(resources.GetObject("panel1.Visible")));
			// 
			// groupBox5
			// 
			this.groupBox5.AccessibleDescription = resources.GetString("groupBox5.AccessibleDescription");
			this.groupBox5.AccessibleName = resources.GetString("groupBox5.AccessibleName");
			this.groupBox5.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("groupBox5.Anchor")));
			this.groupBox5.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("groupBox5.BackgroundImage")));
			this.groupBox5.Controls.Add(this.btnRedoLatest);
			this.groupBox5.Controls.Add(this.btnUndoLatest);
			this.groupBox5.Controls.Add(this.btnClearEmpty);
			this.groupBox5.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("groupBox5.Dock")));
			this.groupBox5.Enabled = ((bool)(resources.GetObject("groupBox5.Enabled")));
			this.groupBox5.Font = ((System.Drawing.Font)(resources.GetObject("groupBox5.Font")));
			this.groupBox5.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("groupBox5.ImeMode")));
			this.groupBox5.Location = ((System.Drawing.Point)(resources.GetObject("groupBox5.Location")));
			this.groupBox5.Name = "groupBox5";
			this.groupBox5.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("groupBox5.RightToLeft")));
			this.groupBox5.Size = ((System.Drawing.Size)(resources.GetObject("groupBox5.Size")));
			this.groupBox5.TabIndex = ((int)(resources.GetObject("groupBox5.TabIndex")));
			this.groupBox5.TabStop = false;
			this.groupBox5.Text = resources.GetString("groupBox5.Text");
			this.groupBox5.Visible = ((bool)(resources.GetObject("groupBox5.Visible")));
			// 
			// btnRedoLatest
			// 
			this.btnRedoLatest.AccessibleDescription = resources.GetString("btnRedoLatest.AccessibleDescription");
			this.btnRedoLatest.AccessibleName = resources.GetString("btnRedoLatest.AccessibleName");
			this.btnRedoLatest.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnRedoLatest.Anchor")));
			this.btnRedoLatest.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnRedoLatest.BackgroundImage")));
			this.btnRedoLatest.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnRedoLatest.Dock")));
			this.btnRedoLatest.Enabled = ((bool)(resources.GetObject("btnRedoLatest.Enabled")));
			this.btnRedoLatest.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnRedoLatest.FlatStyle")));
			this.btnRedoLatest.Font = ((System.Drawing.Font)(resources.GetObject("btnRedoLatest.Font")));
			this.btnRedoLatest.Image = ((System.Drawing.Image)(resources.GetObject("btnRedoLatest.Image")));
			this.btnRedoLatest.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnRedoLatest.ImageAlign")));
			this.btnRedoLatest.ImageIndex = ((int)(resources.GetObject("btnRedoLatest.ImageIndex")));
			this.btnRedoLatest.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnRedoLatest.ImeMode")));
			this.btnRedoLatest.Location = ((System.Drawing.Point)(resources.GetObject("btnRedoLatest.Location")));
			this.btnRedoLatest.Name = "btnRedoLatest";
			this.btnRedoLatest.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnRedoLatest.RightToLeft")));
			this.btnRedoLatest.Size = ((System.Drawing.Size)(resources.GetObject("btnRedoLatest.Size")));
			this.btnRedoLatest.TabIndex = ((int)(resources.GetObject("btnRedoLatest.TabIndex")));
			this.btnRedoLatest.Text = resources.GetString("btnRedoLatest.Text");
			this.btnRedoLatest.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnRedoLatest.TextAlign")));
			this.btnRedoLatest.Visible = ((bool)(resources.GetObject("btnRedoLatest.Visible")));
			this.btnRedoLatest.Click += new System.EventHandler(this.btnRedoLatest_Click);
			// 
			// btnUndoLatest
			// 
			this.btnUndoLatest.AccessibleDescription = resources.GetString("btnUndoLatest.AccessibleDescription");
			this.btnUndoLatest.AccessibleName = resources.GetString("btnUndoLatest.AccessibleName");
			this.btnUndoLatest.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnUndoLatest.Anchor")));
			this.btnUndoLatest.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnUndoLatest.BackgroundImage")));
			this.btnUndoLatest.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnUndoLatest.Dock")));
			this.btnUndoLatest.Enabled = ((bool)(resources.GetObject("btnUndoLatest.Enabled")));
			this.btnUndoLatest.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnUndoLatest.FlatStyle")));
			this.btnUndoLatest.Font = ((System.Drawing.Font)(resources.GetObject("btnUndoLatest.Font")));
			this.btnUndoLatest.Image = ((System.Drawing.Image)(resources.GetObject("btnUndoLatest.Image")));
			this.btnUndoLatest.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnUndoLatest.ImageAlign")));
			this.btnUndoLatest.ImageIndex = ((int)(resources.GetObject("btnUndoLatest.ImageIndex")));
			this.btnUndoLatest.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnUndoLatest.ImeMode")));
			this.btnUndoLatest.Location = ((System.Drawing.Point)(resources.GetObject("btnUndoLatest.Location")));
			this.btnUndoLatest.Name = "btnUndoLatest";
			this.btnUndoLatest.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnUndoLatest.RightToLeft")));
			this.btnUndoLatest.Size = ((System.Drawing.Size)(resources.GetObject("btnUndoLatest.Size")));
			this.btnUndoLatest.TabIndex = ((int)(resources.GetObject("btnUndoLatest.TabIndex")));
			this.btnUndoLatest.Text = resources.GetString("btnUndoLatest.Text");
			this.btnUndoLatest.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnUndoLatest.TextAlign")));
			this.btnUndoLatest.Visible = ((bool)(resources.GetObject("btnUndoLatest.Visible")));
			this.btnUndoLatest.Click += new System.EventHandler(this.btnUndoLatest_Click);
			// 
			// btnClearEmpty
			// 
			this.btnClearEmpty.AccessibleDescription = resources.GetString("btnClearEmpty.AccessibleDescription");
			this.btnClearEmpty.AccessibleName = resources.GetString("btnClearEmpty.AccessibleName");
			this.btnClearEmpty.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnClearEmpty.Anchor")));
			this.btnClearEmpty.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnClearEmpty.BackgroundImage")));
			this.btnClearEmpty.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnClearEmpty.Dock")));
			this.btnClearEmpty.Enabled = ((bool)(resources.GetObject("btnClearEmpty.Enabled")));
			this.btnClearEmpty.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnClearEmpty.FlatStyle")));
			this.btnClearEmpty.Font = ((System.Drawing.Font)(resources.GetObject("btnClearEmpty.Font")));
			this.btnClearEmpty.Image = ((System.Drawing.Image)(resources.GetObject("btnClearEmpty.Image")));
			this.btnClearEmpty.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnClearEmpty.ImageAlign")));
			this.btnClearEmpty.ImageIndex = ((int)(resources.GetObject("btnClearEmpty.ImageIndex")));
			this.btnClearEmpty.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnClearEmpty.ImeMode")));
			this.btnClearEmpty.Location = ((System.Drawing.Point)(resources.GetObject("btnClearEmpty.Location")));
			this.btnClearEmpty.Name = "btnClearEmpty";
			this.btnClearEmpty.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnClearEmpty.RightToLeft")));
			this.btnClearEmpty.Size = ((System.Drawing.Size)(resources.GetObject("btnClearEmpty.Size")));
			this.btnClearEmpty.TabIndex = ((int)(resources.GetObject("btnClearEmpty.TabIndex")));
			this.btnClearEmpty.Text = resources.GetString("btnClearEmpty.Text");
			this.btnClearEmpty.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnClearEmpty.TextAlign")));
			this.btnClearEmpty.Visible = ((bool)(resources.GetObject("btnClearEmpty.Visible")));
			this.btnClearEmpty.Click += new System.EventHandler(this.btnClearEmpty_Click);
			// 
			// groupBox4
			// 
			this.groupBox4.AccessibleDescription = resources.GetString("groupBox4.AccessibleDescription");
			this.groupBox4.AccessibleName = resources.GetString("groupBox4.AccessibleName");
			this.groupBox4.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("groupBox4.Anchor")));
			this.groupBox4.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("groupBox4.BackgroundImage")));
			this.groupBox4.Controls.Add(this.btnNamedCheckPoint);
			this.groupBox4.Controls.Add(this.tbxUndoName);
			this.groupBox4.Controls.Add(this.btnSetCheckPoint);
			this.groupBox4.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("groupBox4.Dock")));
			this.groupBox4.Enabled = ((bool)(resources.GetObject("groupBox4.Enabled")));
			this.groupBox4.Font = ((System.Drawing.Font)(resources.GetObject("groupBox4.Font")));
			this.groupBox4.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("groupBox4.ImeMode")));
			this.groupBox4.Location = ((System.Drawing.Point)(resources.GetObject("groupBox4.Location")));
			this.groupBox4.Name = "groupBox4";
			this.groupBox4.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("groupBox4.RightToLeft")));
			this.groupBox4.Size = ((System.Drawing.Size)(resources.GetObject("groupBox4.Size")));
			this.groupBox4.TabIndex = ((int)(resources.GetObject("groupBox4.TabIndex")));
			this.groupBox4.TabStop = false;
			this.groupBox4.Text = resources.GetString("groupBox4.Text");
			this.groupBox4.Visible = ((bool)(resources.GetObject("groupBox4.Visible")));
			// 
			// btnNamedCheckPoint
			// 
			this.btnNamedCheckPoint.AccessibleDescription = resources.GetString("btnNamedCheckPoint.AccessibleDescription");
			this.btnNamedCheckPoint.AccessibleName = resources.GetString("btnNamedCheckPoint.AccessibleName");
			this.btnNamedCheckPoint.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnNamedCheckPoint.Anchor")));
			this.btnNamedCheckPoint.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnNamedCheckPoint.BackgroundImage")));
			this.btnNamedCheckPoint.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnNamedCheckPoint.Dock")));
			this.btnNamedCheckPoint.Enabled = ((bool)(resources.GetObject("btnNamedCheckPoint.Enabled")));
			this.btnNamedCheckPoint.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnNamedCheckPoint.FlatStyle")));
			this.btnNamedCheckPoint.Font = ((System.Drawing.Font)(resources.GetObject("btnNamedCheckPoint.Font")));
			this.btnNamedCheckPoint.Image = ((System.Drawing.Image)(resources.GetObject("btnNamedCheckPoint.Image")));
			this.btnNamedCheckPoint.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnNamedCheckPoint.ImageAlign")));
			this.btnNamedCheckPoint.ImageIndex = ((int)(resources.GetObject("btnNamedCheckPoint.ImageIndex")));
			this.btnNamedCheckPoint.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnNamedCheckPoint.ImeMode")));
			this.btnNamedCheckPoint.Location = ((System.Drawing.Point)(resources.GetObject("btnNamedCheckPoint.Location")));
			this.btnNamedCheckPoint.Name = "btnNamedCheckPoint";
			this.btnNamedCheckPoint.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnNamedCheckPoint.RightToLeft")));
			this.btnNamedCheckPoint.Size = ((System.Drawing.Size)(resources.GetObject("btnNamedCheckPoint.Size")));
			this.btnNamedCheckPoint.TabIndex = ((int)(resources.GetObject("btnNamedCheckPoint.TabIndex")));
			this.btnNamedCheckPoint.Text = resources.GetString("btnNamedCheckPoint.Text");
			this.btnNamedCheckPoint.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnNamedCheckPoint.TextAlign")));
			this.btnNamedCheckPoint.Visible = ((bool)(resources.GetObject("btnNamedCheckPoint.Visible")));
			this.btnNamedCheckPoint.Click += new System.EventHandler(this.btnNamedCheckPoint_Click);
			// 
			// tbxUndoName
			// 
			this.tbxUndoName.AccessibleDescription = resources.GetString("tbxUndoName.AccessibleDescription");
			this.tbxUndoName.AccessibleName = resources.GetString("tbxUndoName.AccessibleName");
			this.tbxUndoName.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("tbxUndoName.Anchor")));
			this.tbxUndoName.AutoSize = ((bool)(resources.GetObject("tbxUndoName.AutoSize")));
			this.tbxUndoName.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("tbxUndoName.BackgroundImage")));
			this.tbxUndoName.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("tbxUndoName.Dock")));
			this.tbxUndoName.Enabled = ((bool)(resources.GetObject("tbxUndoName.Enabled")));
			this.tbxUndoName.Font = ((System.Drawing.Font)(resources.GetObject("tbxUndoName.Font")));
			this.tbxUndoName.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("tbxUndoName.ImeMode")));
			this.tbxUndoName.Location = ((System.Drawing.Point)(resources.GetObject("tbxUndoName.Location")));
			this.tbxUndoName.MaxLength = ((int)(resources.GetObject("tbxUndoName.MaxLength")));
			this.tbxUndoName.Multiline = ((bool)(resources.GetObject("tbxUndoName.Multiline")));
			this.tbxUndoName.Name = "tbxUndoName";
			this.tbxUndoName.PasswordChar = ((char)(resources.GetObject("tbxUndoName.PasswordChar")));
			this.tbxUndoName.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("tbxUndoName.RightToLeft")));
			this.tbxUndoName.ScrollBars = ((System.Windows.Forms.ScrollBars)(resources.GetObject("tbxUndoName.ScrollBars")));
			this.tbxUndoName.Size = ((System.Drawing.Size)(resources.GetObject("tbxUndoName.Size")));
			this.tbxUndoName.TabIndex = ((int)(resources.GetObject("tbxUndoName.TabIndex")));
			this.tbxUndoName.Text = resources.GetString("tbxUndoName.Text");
			this.tbxUndoName.TextAlign = ((System.Windows.Forms.HorizontalAlignment)(resources.GetObject("tbxUndoName.TextAlign")));
			this.tbxUndoName.Visible = ((bool)(resources.GetObject("tbxUndoName.Visible")));
			this.tbxUndoName.WordWrap = ((bool)(resources.GetObject("tbxUndoName.WordWrap")));
			// 
			// btnSetCheckPoint
			// 
			this.btnSetCheckPoint.AccessibleDescription = resources.GetString("btnSetCheckPoint.AccessibleDescription");
			this.btnSetCheckPoint.AccessibleName = resources.GetString("btnSetCheckPoint.AccessibleName");
			this.btnSetCheckPoint.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnSetCheckPoint.Anchor")));
			this.btnSetCheckPoint.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnSetCheckPoint.BackgroundImage")));
			this.btnSetCheckPoint.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnSetCheckPoint.Dock")));
			this.btnSetCheckPoint.Enabled = ((bool)(resources.GetObject("btnSetCheckPoint.Enabled")));
			this.btnSetCheckPoint.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnSetCheckPoint.FlatStyle")));
			this.btnSetCheckPoint.Font = ((System.Drawing.Font)(resources.GetObject("btnSetCheckPoint.Font")));
			this.btnSetCheckPoint.Image = ((System.Drawing.Image)(resources.GetObject("btnSetCheckPoint.Image")));
			this.btnSetCheckPoint.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnSetCheckPoint.ImageAlign")));
			this.btnSetCheckPoint.ImageIndex = ((int)(resources.GetObject("btnSetCheckPoint.ImageIndex")));
			this.btnSetCheckPoint.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnSetCheckPoint.ImeMode")));
			this.btnSetCheckPoint.Location = ((System.Drawing.Point)(resources.GetObject("btnSetCheckPoint.Location")));
			this.btnSetCheckPoint.Name = "btnSetCheckPoint";
			this.btnSetCheckPoint.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnSetCheckPoint.RightToLeft")));
			this.btnSetCheckPoint.Size = ((System.Drawing.Size)(resources.GetObject("btnSetCheckPoint.Size")));
			this.btnSetCheckPoint.TabIndex = ((int)(resources.GetObject("btnSetCheckPoint.TabIndex")));
			this.btnSetCheckPoint.Text = resources.GetString("btnSetCheckPoint.Text");
			this.btnSetCheckPoint.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnSetCheckPoint.TextAlign")));
			this.btnSetCheckPoint.Visible = ((bool)(resources.GetObject("btnSetCheckPoint.Visible")));
			this.btnSetCheckPoint.Click += new System.EventHandler(this.button5_Click);
			// 
			// groupBox3
			// 
			this.groupBox3.AccessibleDescription = resources.GetString("groupBox3.AccessibleDescription");
			this.groupBox3.AccessibleName = resources.GetString("groupBox3.AccessibleName");
			this.groupBox3.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("groupBox3.Anchor")));
			this.groupBox3.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("groupBox3.BackgroundImage")));
			this.groupBox3.Controls.Add(this.lbxRedoblocks);
			this.groupBox3.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("groupBox3.Dock")));
			this.groupBox3.Enabled = ((bool)(resources.GetObject("groupBox3.Enabled")));
			this.groupBox3.Font = ((System.Drawing.Font)(resources.GetObject("groupBox3.Font")));
			this.groupBox3.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("groupBox3.ImeMode")));
			this.groupBox3.Location = ((System.Drawing.Point)(resources.GetObject("groupBox3.Location")));
			this.groupBox3.Name = "groupBox3";
			this.groupBox3.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("groupBox3.RightToLeft")));
			this.groupBox3.Size = ((System.Drawing.Size)(resources.GetObject("groupBox3.Size")));
			this.groupBox3.TabIndex = ((int)(resources.GetObject("groupBox3.TabIndex")));
			this.groupBox3.TabStop = false;
			this.groupBox3.Text = resources.GetString("groupBox3.Text");
			this.groupBox3.Visible = ((bool)(resources.GetObject("groupBox3.Visible")));
			// 
			// lbxRedoblocks
			// 
			this.lbxRedoblocks.AccessibleDescription = resources.GetString("lbxRedoblocks.AccessibleDescription");
			this.lbxRedoblocks.AccessibleName = resources.GetString("lbxRedoblocks.AccessibleName");
			this.lbxRedoblocks.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("lbxRedoblocks.Anchor")));
			this.lbxRedoblocks.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("lbxRedoblocks.BackgroundImage")));
			this.lbxRedoblocks.ColumnWidth = ((int)(resources.GetObject("lbxRedoblocks.ColumnWidth")));
			this.lbxRedoblocks.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("lbxRedoblocks.Dock")));
			this.lbxRedoblocks.Enabled = ((bool)(resources.GetObject("lbxRedoblocks.Enabled")));
			this.lbxRedoblocks.Font = ((System.Drawing.Font)(resources.GetObject("lbxRedoblocks.Font")));
			this.lbxRedoblocks.HorizontalExtent = ((int)(resources.GetObject("lbxRedoblocks.HorizontalExtent")));
			this.lbxRedoblocks.HorizontalScrollbar = ((bool)(resources.GetObject("lbxRedoblocks.HorizontalScrollbar")));
			this.lbxRedoblocks.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("lbxRedoblocks.ImeMode")));
			this.lbxRedoblocks.IntegralHeight = ((bool)(resources.GetObject("lbxRedoblocks.IntegralHeight")));
			this.lbxRedoblocks.ItemHeight = ((int)(resources.GetObject("lbxRedoblocks.ItemHeight")));
			this.lbxRedoblocks.Location = ((System.Drawing.Point)(resources.GetObject("lbxRedoblocks.Location")));
			this.lbxRedoblocks.Name = "lbxRedoblocks";
			this.lbxRedoblocks.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("lbxRedoblocks.RightToLeft")));
			this.lbxRedoblocks.ScrollAlwaysVisible = ((bool)(resources.GetObject("lbxRedoblocks.ScrollAlwaysVisible")));
			this.lbxRedoblocks.Size = ((System.Drawing.Size)(resources.GetObject("lbxRedoblocks.Size")));
			this.lbxRedoblocks.TabIndex = ((int)(resources.GetObject("lbxRedoblocks.TabIndex")));
			this.lbxRedoblocks.Visible = ((bool)(resources.GetObject("lbxRedoblocks.Visible")));
			// 
			// groupBox2
			// 
			this.groupBox2.AccessibleDescription = resources.GetString("groupBox2.AccessibleDescription");
			this.groupBox2.AccessibleName = resources.GetString("groupBox2.AccessibleName");
			this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("groupBox2.Anchor")));
			this.groupBox2.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("groupBox2.BackgroundImage")));
			this.groupBox2.Controls.Add(this.label1);
			this.groupBox2.Controls.Add(this.btnUndoSelected);
			this.groupBox2.Controls.Add(this.lbxUndoblocks);
			this.groupBox2.Controls.Add(this.btnRefresh);
			this.groupBox2.Controls.Add(this.btnMoveSelectedUndoUp);
			this.groupBox2.Controls.Add(this.btnMoveSelectedUndoDown);
			this.groupBox2.Controls.Add(this.listBox2);
			this.groupBox2.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("groupBox2.Dock")));
			this.groupBox2.Enabled = ((bool)(resources.GetObject("groupBox2.Enabled")));
			this.groupBox2.Font = ((System.Drawing.Font)(resources.GetObject("groupBox2.Font")));
			this.groupBox2.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("groupBox2.ImeMode")));
			this.groupBox2.Location = ((System.Drawing.Point)(resources.GetObject("groupBox2.Location")));
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("groupBox2.RightToLeft")));
			this.groupBox2.Size = ((System.Drawing.Size)(resources.GetObject("groupBox2.Size")));
			this.groupBox2.TabIndex = ((int)(resources.GetObject("groupBox2.TabIndex")));
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = resources.GetString("groupBox2.Text");
			this.groupBox2.Visible = ((bool)(resources.GetObject("groupBox2.Visible")));
			// 
			// label1
			// 
			this.label1.AccessibleDescription = resources.GetString("label1.AccessibleDescription");
			this.label1.AccessibleName = resources.GetString("label1.AccessibleName");
			this.label1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("label1.Anchor")));
			this.label1.AutoSize = ((bool)(resources.GetObject("label1.AutoSize")));
			this.label1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("label1.Dock")));
			this.label1.Enabled = ((bool)(resources.GetObject("label1.Enabled")));
			this.label1.Font = ((System.Drawing.Font)(resources.GetObject("label1.Font")));
			this.label1.Image = ((System.Drawing.Image)(resources.GetObject("label1.Image")));
			this.label1.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("label1.ImageAlign")));
			this.label1.ImageIndex = ((int)(resources.GetObject("label1.ImageIndex")));
			this.label1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("label1.ImeMode")));
			this.label1.Location = ((System.Drawing.Point)(resources.GetObject("label1.Location")));
			this.label1.Name = "label1";
			this.label1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("label1.RightToLeft")));
			this.label1.Size = ((System.Drawing.Size)(resources.GetObject("label1.Size")));
			this.label1.TabIndex = ((int)(resources.GetObject("label1.TabIndex")));
			this.label1.Text = resources.GetString("label1.Text");
			this.label1.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("label1.TextAlign")));
			this.label1.Visible = ((bool)(resources.GetObject("label1.Visible")));
			// 
			// btnUndoSelected
			// 
			this.btnUndoSelected.AccessibleDescription = resources.GetString("btnUndoSelected.AccessibleDescription");
			this.btnUndoSelected.AccessibleName = resources.GetString("btnUndoSelected.AccessibleName");
			this.btnUndoSelected.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnUndoSelected.Anchor")));
			this.btnUndoSelected.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnUndoSelected.BackgroundImage")));
			this.btnUndoSelected.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnUndoSelected.Dock")));
			this.btnUndoSelected.Enabled = ((bool)(resources.GetObject("btnUndoSelected.Enabled")));
			this.btnUndoSelected.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnUndoSelected.FlatStyle")));
			this.btnUndoSelected.Font = ((System.Drawing.Font)(resources.GetObject("btnUndoSelected.Font")));
			this.btnUndoSelected.Image = ((System.Drawing.Image)(resources.GetObject("btnUndoSelected.Image")));
			this.btnUndoSelected.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnUndoSelected.ImageAlign")));
			this.btnUndoSelected.ImageIndex = ((int)(resources.GetObject("btnUndoSelected.ImageIndex")));
			this.btnUndoSelected.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnUndoSelected.ImeMode")));
			this.btnUndoSelected.Location = ((System.Drawing.Point)(resources.GetObject("btnUndoSelected.Location")));
			this.btnUndoSelected.Name = "btnUndoSelected";
			this.btnUndoSelected.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnUndoSelected.RightToLeft")));
			this.btnUndoSelected.Size = ((System.Drawing.Size)(resources.GetObject("btnUndoSelected.Size")));
			this.btnUndoSelected.TabIndex = ((int)(resources.GetObject("btnUndoSelected.TabIndex")));
			this.btnUndoSelected.Text = resources.GetString("btnUndoSelected.Text");
			this.btnUndoSelected.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnUndoSelected.TextAlign")));
			this.btnUndoSelected.Visible = ((bool)(resources.GetObject("btnUndoSelected.Visible")));
			this.btnUndoSelected.Click += new System.EventHandler(this.btnUndoSelected_Click);
			// 
			// lbxUndoblocks
			// 
			this.lbxUndoblocks.AccessibleDescription = resources.GetString("lbxUndoblocks.AccessibleDescription");
			this.lbxUndoblocks.AccessibleName = resources.GetString("lbxUndoblocks.AccessibleName");
			this.lbxUndoblocks.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("lbxUndoblocks.Anchor")));
			this.lbxUndoblocks.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("lbxUndoblocks.BackgroundImage")));
			this.lbxUndoblocks.ColumnWidth = ((int)(resources.GetObject("lbxUndoblocks.ColumnWidth")));
			this.lbxUndoblocks.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("lbxUndoblocks.Dock")));
			this.lbxUndoblocks.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
			this.lbxUndoblocks.Enabled = ((bool)(resources.GetObject("lbxUndoblocks.Enabled")));
			this.lbxUndoblocks.Font = ((System.Drawing.Font)(resources.GetObject("lbxUndoblocks.Font")));
			this.lbxUndoblocks.HorizontalExtent = ((int)(resources.GetObject("lbxUndoblocks.HorizontalExtent")));
			this.lbxUndoblocks.HorizontalScrollbar = ((bool)(resources.GetObject("lbxUndoblocks.HorizontalScrollbar")));
			this.lbxUndoblocks.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("lbxUndoblocks.ImeMode")));
			this.lbxUndoblocks.IntegralHeight = ((bool)(resources.GetObject("lbxUndoblocks.IntegralHeight")));
			this.lbxUndoblocks.ItemHeight = ((int)(resources.GetObject("lbxUndoblocks.ItemHeight")));
			this.lbxUndoblocks.Location = ((System.Drawing.Point)(resources.GetObject("lbxUndoblocks.Location")));
			this.lbxUndoblocks.Name = "lbxUndoblocks";
			this.lbxUndoblocks.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("lbxUndoblocks.RightToLeft")));
			this.lbxUndoblocks.ScrollAlwaysVisible = ((bool)(resources.GetObject("lbxUndoblocks.ScrollAlwaysVisible")));
			this.lbxUndoblocks.Size = ((System.Drawing.Size)(resources.GetObject("lbxUndoblocks.Size")));
			this.lbxUndoblocks.TabIndex = ((int)(resources.GetObject("lbxUndoblocks.TabIndex")));
			this.lbxUndoblocks.Visible = ((bool)(resources.GetObject("lbxUndoblocks.Visible")));
			this.lbxUndoblocks.DrawItem += new System.Windows.Forms.DrawItemEventHandler(this.lbxUndoblocks_DrawItem);
			this.lbxUndoblocks.SelectedIndexChanged += new System.EventHandler(this.lbxUndoblocks_SelectedIndexChanged);
			// 
			// btnRefresh
			// 
			this.btnRefresh.AccessibleDescription = resources.GetString("btnRefresh.AccessibleDescription");
			this.btnRefresh.AccessibleName = resources.GetString("btnRefresh.AccessibleName");
			this.btnRefresh.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnRefresh.Anchor")));
			this.btnRefresh.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnRefresh.BackgroundImage")));
			this.btnRefresh.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnRefresh.Dock")));
			this.btnRefresh.Enabled = ((bool)(resources.GetObject("btnRefresh.Enabled")));
			this.btnRefresh.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnRefresh.FlatStyle")));
			this.btnRefresh.Font = ((System.Drawing.Font)(resources.GetObject("btnRefresh.Font")));
			this.btnRefresh.Image = ((System.Drawing.Image)(resources.GetObject("btnRefresh.Image")));
			this.btnRefresh.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnRefresh.ImageAlign")));
			this.btnRefresh.ImageIndex = ((int)(resources.GetObject("btnRefresh.ImageIndex")));
			this.btnRefresh.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnRefresh.ImeMode")));
			this.btnRefresh.Location = ((System.Drawing.Point)(resources.GetObject("btnRefresh.Location")));
			this.btnRefresh.Name = "btnRefresh";
			this.btnRefresh.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnRefresh.RightToLeft")));
			this.btnRefresh.Size = ((System.Drawing.Size)(resources.GetObject("btnRefresh.Size")));
			this.btnRefresh.TabIndex = ((int)(resources.GetObject("btnRefresh.TabIndex")));
			this.btnRefresh.Text = resources.GetString("btnRefresh.Text");
			this.btnRefresh.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnRefresh.TextAlign")));
			this.btnRefresh.Visible = ((bool)(resources.GetObject("btnRefresh.Visible")));
			this.btnRefresh.Click += new System.EventHandler(this.button4_Click);
			// 
			// btnMoveSelectedUndoUp
			// 
			this.btnMoveSelectedUndoUp.AccessibleDescription = resources.GetString("btnMoveSelectedUndoUp.AccessibleDescription");
			this.btnMoveSelectedUndoUp.AccessibleName = resources.GetString("btnMoveSelectedUndoUp.AccessibleName");
			this.btnMoveSelectedUndoUp.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnMoveSelectedUndoUp.Anchor")));
			this.btnMoveSelectedUndoUp.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnMoveSelectedUndoUp.BackgroundImage")));
			this.btnMoveSelectedUndoUp.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnMoveSelectedUndoUp.Dock")));
			this.btnMoveSelectedUndoUp.Enabled = ((bool)(resources.GetObject("btnMoveSelectedUndoUp.Enabled")));
			this.btnMoveSelectedUndoUp.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnMoveSelectedUndoUp.FlatStyle")));
			this.btnMoveSelectedUndoUp.Font = ((System.Drawing.Font)(resources.GetObject("btnMoveSelectedUndoUp.Font")));
			this.btnMoveSelectedUndoUp.Image = ((System.Drawing.Image)(resources.GetObject("btnMoveSelectedUndoUp.Image")));
			this.btnMoveSelectedUndoUp.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnMoveSelectedUndoUp.ImageAlign")));
			this.btnMoveSelectedUndoUp.ImageIndex = ((int)(resources.GetObject("btnMoveSelectedUndoUp.ImageIndex")));
			this.btnMoveSelectedUndoUp.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnMoveSelectedUndoUp.ImeMode")));
			this.btnMoveSelectedUndoUp.Location = ((System.Drawing.Point)(resources.GetObject("btnMoveSelectedUndoUp.Location")));
			this.btnMoveSelectedUndoUp.Name = "btnMoveSelectedUndoUp";
			this.btnMoveSelectedUndoUp.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnMoveSelectedUndoUp.RightToLeft")));
			this.btnMoveSelectedUndoUp.Size = ((System.Drawing.Size)(resources.GetObject("btnMoveSelectedUndoUp.Size")));
			this.btnMoveSelectedUndoUp.TabIndex = ((int)(resources.GetObject("btnMoveSelectedUndoUp.TabIndex")));
			this.btnMoveSelectedUndoUp.Text = resources.GetString("btnMoveSelectedUndoUp.Text");
			this.btnMoveSelectedUndoUp.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnMoveSelectedUndoUp.TextAlign")));
			this.btnMoveSelectedUndoUp.Visible = ((bool)(resources.GetObject("btnMoveSelectedUndoUp.Visible")));
			this.btnMoveSelectedUndoUp.Click += new System.EventHandler(this.btnMoveSelectedUndoUp_Click);
			// 
			// btnMoveSelectedUndoDown
			// 
			this.btnMoveSelectedUndoDown.AccessibleDescription = resources.GetString("btnMoveSelectedUndoDown.AccessibleDescription");
			this.btnMoveSelectedUndoDown.AccessibleName = resources.GetString("btnMoveSelectedUndoDown.AccessibleName");
			this.btnMoveSelectedUndoDown.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnMoveSelectedUndoDown.Anchor")));
			this.btnMoveSelectedUndoDown.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnMoveSelectedUndoDown.BackgroundImage")));
			this.btnMoveSelectedUndoDown.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnMoveSelectedUndoDown.Dock")));
			this.btnMoveSelectedUndoDown.Enabled = ((bool)(resources.GetObject("btnMoveSelectedUndoDown.Enabled")));
			this.btnMoveSelectedUndoDown.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnMoveSelectedUndoDown.FlatStyle")));
			this.btnMoveSelectedUndoDown.Font = ((System.Drawing.Font)(resources.GetObject("btnMoveSelectedUndoDown.Font")));
			this.btnMoveSelectedUndoDown.Image = ((System.Drawing.Image)(resources.GetObject("btnMoveSelectedUndoDown.Image")));
			this.btnMoveSelectedUndoDown.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnMoveSelectedUndoDown.ImageAlign")));
			this.btnMoveSelectedUndoDown.ImageIndex = ((int)(resources.GetObject("btnMoveSelectedUndoDown.ImageIndex")));
			this.btnMoveSelectedUndoDown.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnMoveSelectedUndoDown.ImeMode")));
			this.btnMoveSelectedUndoDown.Location = ((System.Drawing.Point)(resources.GetObject("btnMoveSelectedUndoDown.Location")));
			this.btnMoveSelectedUndoDown.Name = "btnMoveSelectedUndoDown";
			this.btnMoveSelectedUndoDown.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnMoveSelectedUndoDown.RightToLeft")));
			this.btnMoveSelectedUndoDown.Size = ((System.Drawing.Size)(resources.GetObject("btnMoveSelectedUndoDown.Size")));
			this.btnMoveSelectedUndoDown.TabIndex = ((int)(resources.GetObject("btnMoveSelectedUndoDown.TabIndex")));
			this.btnMoveSelectedUndoDown.Text = resources.GetString("btnMoveSelectedUndoDown.Text");
			this.btnMoveSelectedUndoDown.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnMoveSelectedUndoDown.TextAlign")));
			this.btnMoveSelectedUndoDown.Visible = ((bool)(resources.GetObject("btnMoveSelectedUndoDown.Visible")));
			this.btnMoveSelectedUndoDown.Click += new System.EventHandler(this.btnMoveSelectedUndoDown_Click);
			// 
			// listBox2
			// 
			this.listBox2.AccessibleDescription = resources.GetString("listBox2.AccessibleDescription");
			this.listBox2.AccessibleName = resources.GetString("listBox2.AccessibleName");
			this.listBox2.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("listBox2.Anchor")));
			this.listBox2.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("listBox2.BackgroundImage")));
			this.listBox2.ColumnWidth = ((int)(resources.GetObject("listBox2.ColumnWidth")));
			this.listBox2.DataSource = this.referenceHandle1;
			this.listBox2.DisplayMember = "AsString";
			this.listBox2.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("listBox2.Dock")));
			this.ecoAutoFormExtender1.SetEcoAutoForm(this.listBox2, true);
			this.ecoDragDropExtender1.SetEcoDragSource(this.listBox2, true);
			this.listBox2.Enabled = ((bool)(resources.GetObject("listBox2.Enabled")));
			this.listBox2.Font = ((System.Drawing.Font)(resources.GetObject("listBox2.Font")));
			this.listBox2.HorizontalExtent = ((int)(resources.GetObject("listBox2.HorizontalExtent")));
			this.listBox2.HorizontalScrollbar = ((bool)(resources.GetObject("listBox2.HorizontalScrollbar")));
			this.listBox2.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("listBox2.ImeMode")));
			this.listBox2.IntegralHeight = ((bool)(resources.GetObject("listBox2.IntegralHeight")));
			this.listBox2.ItemHeight = ((int)(resources.GetObject("listBox2.ItemHeight")));
			this.listBox2.Location = ((System.Drawing.Point)(resources.GetObject("listBox2.Location")));
			this.listBox2.Name = "listBox2";
			this.listBox2.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("listBox2.RightToLeft")));
			this.listBox2.ScrollAlwaysVisible = ((bool)(resources.GetObject("listBox2.ScrollAlwaysVisible")));
			this.listBox2.Size = ((System.Drawing.Size)(resources.GetObject("listBox2.Size")));
			this.listBox2.TabIndex = ((int)(resources.GetObject("listBox2.TabIndex")));
			this.listBox2.Visible = ((bool)(resources.GetObject("listBox2.Visible")));
			// 
			// referenceHandle1
			// 
			oclColumn11.Expression = "self.AsString";
			oclColumn11.Name = "AsString";
			this.referenceHandle1.Columns.AddRange(new Borland.Eco.Handles.AbstractColumn[] {
						oclColumn11});
			// 
			// groupBox1
			// 
			this.groupBox1.AccessibleDescription = resources.GetString("groupBox1.AccessibleDescription");
			this.groupBox1.AccessibleName = resources.GetString("groupBox1.AccessibleName");
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("groupBox1.Anchor")));
			this.groupBox1.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("groupBox1.BackgroundImage")));
			this.groupBox1.Controls.Add(this.btnStartTransaction);
			this.groupBox1.Controls.Add(this.btnRollbackTransaction);
			this.groupBox1.Controls.Add(this.btnCommitTransaction);
			this.groupBox1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("groupBox1.Dock")));
			this.groupBox1.Enabled = ((bool)(resources.GetObject("groupBox1.Enabled")));
			this.groupBox1.Font = ((System.Drawing.Font)(resources.GetObject("groupBox1.Font")));
			this.groupBox1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("groupBox1.ImeMode")));
			this.groupBox1.Location = ((System.Drawing.Point)(resources.GetObject("groupBox1.Location")));
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("groupBox1.RightToLeft")));
			this.groupBox1.Size = ((System.Drawing.Size)(resources.GetObject("groupBox1.Size")));
			this.groupBox1.TabIndex = ((int)(resources.GetObject("groupBox1.TabIndex")));
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = resources.GetString("groupBox1.Text");
			this.groupBox1.Visible = ((bool)(resources.GetObject("groupBox1.Visible")));
			// 
			// btnStartTransaction
			// 
			this.btnStartTransaction.AccessibleDescription = resources.GetString("btnStartTransaction.AccessibleDescription");
			this.btnStartTransaction.AccessibleName = resources.GetString("btnStartTransaction.AccessibleName");
			this.btnStartTransaction.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnStartTransaction.Anchor")));
			this.btnStartTransaction.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnStartTransaction.BackgroundImage")));
			this.btnStartTransaction.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnStartTransaction.Dock")));
			this.btnStartTransaction.Enabled = ((bool)(resources.GetObject("btnStartTransaction.Enabled")));
			this.btnStartTransaction.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnStartTransaction.FlatStyle")));
			this.btnStartTransaction.Font = ((System.Drawing.Font)(resources.GetObject("btnStartTransaction.Font")));
			this.btnStartTransaction.Image = ((System.Drawing.Image)(resources.GetObject("btnStartTransaction.Image")));
			this.btnStartTransaction.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnStartTransaction.ImageAlign")));
			this.btnStartTransaction.ImageIndex = ((int)(resources.GetObject("btnStartTransaction.ImageIndex")));
			this.btnStartTransaction.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnStartTransaction.ImeMode")));
			this.btnStartTransaction.Location = ((System.Drawing.Point)(resources.GetObject("btnStartTransaction.Location")));
			this.btnStartTransaction.Name = "btnStartTransaction";
			this.btnStartTransaction.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnStartTransaction.RightToLeft")));
			this.btnStartTransaction.Size = ((System.Drawing.Size)(resources.GetObject("btnStartTransaction.Size")));
			this.btnStartTransaction.TabIndex = ((int)(resources.GetObject("btnStartTransaction.TabIndex")));
			this.btnStartTransaction.Text = resources.GetString("btnStartTransaction.Text");
			this.btnStartTransaction.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnStartTransaction.TextAlign")));
			this.btnStartTransaction.Visible = ((bool)(resources.GetObject("btnStartTransaction.Visible")));
			this.btnStartTransaction.Click += new System.EventHandler(this.btnStartTransaction_Click);
			// 
			// btnRollbackTransaction
			// 
			this.btnRollbackTransaction.AccessibleDescription = resources.GetString("btnRollbackTransaction.AccessibleDescription");
			this.btnRollbackTransaction.AccessibleName = resources.GetString("btnRollbackTransaction.AccessibleName");
			this.btnRollbackTransaction.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnRollbackTransaction.Anchor")));
			this.btnRollbackTransaction.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnRollbackTransaction.BackgroundImage")));
			this.btnRollbackTransaction.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnRollbackTransaction.Dock")));
			this.btnRollbackTransaction.Enabled = ((bool)(resources.GetObject("btnRollbackTransaction.Enabled")));
			this.btnRollbackTransaction.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnRollbackTransaction.FlatStyle")));
			this.btnRollbackTransaction.Font = ((System.Drawing.Font)(resources.GetObject("btnRollbackTransaction.Font")));
			this.btnRollbackTransaction.Image = ((System.Drawing.Image)(resources.GetObject("btnRollbackTransaction.Image")));
			this.btnRollbackTransaction.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnRollbackTransaction.ImageAlign")));
			this.btnRollbackTransaction.ImageIndex = ((int)(resources.GetObject("btnRollbackTransaction.ImageIndex")));
			this.btnRollbackTransaction.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnRollbackTransaction.ImeMode")));
			this.btnRollbackTransaction.Location = ((System.Drawing.Point)(resources.GetObject("btnRollbackTransaction.Location")));
			this.btnRollbackTransaction.Name = "btnRollbackTransaction";
			this.btnRollbackTransaction.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnRollbackTransaction.RightToLeft")));
			this.btnRollbackTransaction.Size = ((System.Drawing.Size)(resources.GetObject("btnRollbackTransaction.Size")));
			this.btnRollbackTransaction.TabIndex = ((int)(resources.GetObject("btnRollbackTransaction.TabIndex")));
			this.btnRollbackTransaction.Text = resources.GetString("btnRollbackTransaction.Text");
			this.btnRollbackTransaction.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnRollbackTransaction.TextAlign")));
			this.btnRollbackTransaction.Visible = ((bool)(resources.GetObject("btnRollbackTransaction.Visible")));
			this.btnRollbackTransaction.Click += new System.EventHandler(this.btnRollbackTransaction_Click);
			// 
			// btnCommitTransaction
			// 
			this.btnCommitTransaction.AccessibleDescription = resources.GetString("btnCommitTransaction.AccessibleDescription");
			this.btnCommitTransaction.AccessibleName = resources.GetString("btnCommitTransaction.AccessibleName");
			this.btnCommitTransaction.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnCommitTransaction.Anchor")));
			this.btnCommitTransaction.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnCommitTransaction.BackgroundImage")));
			this.btnCommitTransaction.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnCommitTransaction.Dock")));
			this.btnCommitTransaction.Enabled = ((bool)(resources.GetObject("btnCommitTransaction.Enabled")));
			this.btnCommitTransaction.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnCommitTransaction.FlatStyle")));
			this.btnCommitTransaction.Font = ((System.Drawing.Font)(resources.GetObject("btnCommitTransaction.Font")));
			this.btnCommitTransaction.Image = ((System.Drawing.Image)(resources.GetObject("btnCommitTransaction.Image")));
			this.btnCommitTransaction.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnCommitTransaction.ImageAlign")));
			this.btnCommitTransaction.ImageIndex = ((int)(resources.GetObject("btnCommitTransaction.ImageIndex")));
			this.btnCommitTransaction.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnCommitTransaction.ImeMode")));
			this.btnCommitTransaction.Location = ((System.Drawing.Point)(resources.GetObject("btnCommitTransaction.Location")));
			this.btnCommitTransaction.Name = "btnCommitTransaction";
			this.btnCommitTransaction.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnCommitTransaction.RightToLeft")));
			this.btnCommitTransaction.Size = ((System.Drawing.Size)(resources.GetObject("btnCommitTransaction.Size")));
			this.btnCommitTransaction.TabIndex = ((int)(resources.GetObject("btnCommitTransaction.TabIndex")));
			this.btnCommitTransaction.Text = resources.GetString("btnCommitTransaction.Text");
			this.btnCommitTransaction.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnCommitTransaction.TextAlign")));
			this.btnCommitTransaction.Visible = ((bool)(resources.GetObject("btnCommitTransaction.Visible")));
			this.btnCommitTransaction.Click += new System.EventHandler(this.btnCommitTransaction_Click);
			// 
			// mainMenu1
			// 
			this.mainMenu1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("mainMenu1.RightToLeft")));
			// 
			// timer1
			// 
			this.timer1.Enabled = true;
			this.timer1.Interval = 1000;
			this.timer1.Tick += new System.EventHandler(this.timer1_Tick);
			// 
			// UndoDebuggerPanel
			// 
			this.AccessibleDescription = resources.GetString("$this.AccessibleDescription");
			this.AccessibleName = resources.GetString("$this.AccessibleName");
			this.AutoScaleBaseSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScaleBaseSize")));
			this.AutoScroll = ((bool)(resources.GetObject("$this.AutoScroll")));
			this.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMargin")));
			this.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMinSize")));
			this.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("$this.BackgroundImage")));
			this.ClientSize = ((System.Drawing.Size)(resources.GetObject("$this.ClientSize")));
			this.Controls.Add(this.panel1);
			this.Enabled = ((bool)(resources.GetObject("$this.Enabled")));
			this.Font = ((System.Drawing.Font)(resources.GetObject("$this.Font")));
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("$this.ImeMode")));
			this.Location = ((System.Drawing.Point)(resources.GetObject("$this.Location")));
			this.MaximumSize = ((System.Drawing.Size)(resources.GetObject("$this.MaximumSize")));
			this.Menu = this.mainMenu1;
			this.MinimumSize = ((System.Drawing.Size)(resources.GetObject("$this.MinimumSize")));
			this.Name = "UndoDebuggerPanel";
			this.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("$this.RightToLeft")));
			this.StartPosition = ((System.Windows.Forms.FormStartPosition)(resources.GetObject("$this.StartPosition")));
			this.Text = resources.GetString("$this.Text");
			this.Activated += new System.EventHandler(this.UndoDebuggerPanel_Activated);
			this.Deactivate += new System.EventHandler(this.UndoDebuggerPanel_Deactivate);
			this.panel1.ResumeLayout(false);
			this.groupBox5.ResumeLayout(false);
			this.groupBox4.ResumeLayout(false);
			this.groupBox3.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);
		}
		#endregion

		public Borland.Eco.Handles.EcoSpace EcoSpace
		{
			get { return (Borland.Eco.Handles.EcoSpace)rhRoot.EcoSpace; }
			set { rhRoot.EcoSpace = value; }
		}

		private static void SetupDefaultColumns(ElementHandle handle)
		{
			if (handle.Columns.Count == 0)
			{
				OclColumn col1 = new OclColumn();
				col1.Expression = "self.oclType.asString"; // do not localize
				col1.Name = "Type"; // do not localize
				OclColumn col2 = new OclColumn();
				col2.Expression = "self.asString"; // do not localize
				col2.Name = "AsString"; // do not localize
				handle.Columns.AddRange(new AbstractColumn[] {col1, col2});
			}
		}

		Panel IEcoSpaceDebuggerPanel.Panel { get { return panel1; } }
		string IEcoSpaceDebuggerPanel.Caption { get { return FormsStringRes.sUndoRedo; } }
		MainMenu IEcoSpaceDebuggerPanel.MainMenu { get { return mainMenu1; } }
		void IEcoSpaceDebuggerPanel.Init(EcoSpace es)
		{
			this.EcoSpace = es;
            RefreshLists();
		}

		private static void RefreshList(ListBox lbx, IUndoBlockList list)
		{
			int currentIndex = lbx.SelectedIndex;
			object currentItem = null;
			if (currentIndex >= 0)
				currentItem = lbx.Items[currentIndex];
//			lbx.Items.Clear();
			for (int i=0; i<list.Count; i++)
			{
				if (lbx.Items.Count <= i)
					lbx.Items.Add(list[i].Name);
				else if (lbx.Items[i].ToString() != list[i].Name)
					lbx.Items[i] = list[i].Name;
			}
			while (lbx.Items.Count > list.Count)
				lbx.Items.RemoveAt(lbx.Items.Count-1);
			int pos = -1;
			if (currentItem != null)
				pos = lbx.Items.IndexOf(currentItem);
			if (pos != -1)
				lbx.SelectedIndex = pos;
			else if (currentIndex >= 0 && lbx.Items.Count > currentIndex)
				 lbx.SelectedIndex = currentIndex;
		}
		private void RefreshLists()
		{
			RefreshList(lbxUndoblocks, UndoService.UndoList);
			RefreshList(lbxRedoblocks, UndoService.RedoList);
			RefreshButtons();
			RefreshElements();
		}
		private void button4_Click(object sender, System.EventArgs e)
		{
			RefreshLists();
		}

		private void RefreshButtons()
		{
			string selectedBlock = "";
			if (lbxUndoblocks.SelectedItem != null)
				selectedBlock = lbxUndoblocks.SelectedItem.ToString();

			btnUndoSelected.Enabled = lbxUndoblocks.SelectedItem != null && UndoService.CanUndoBlock(selectedBlock);

			int currentIndex = lbxUndoblocks.SelectedIndex;

			btnMoveSelectedUndoUp.Enabled = currentIndex > 0 && UndoService.UndoList.CanMoveBlock(currentIndex, currentIndex-1);
			btnMoveSelectedUndoDown.Enabled = currentIndex >= 0 && currentIndex < UndoService.UndoList.Count-1 && UndoService.UndoList.CanMoveBlock(currentIndex, currentIndex+1);

			btnRedoLatest.Enabled = UndoService.RedoList.Count > 0;
			btnUndoLatest.Enabled = UndoService.UndoList.Count > 0;
		}

		private void lbxUndoblocks_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			RefreshButtons();
			RefreshElements();
		}

		private void RefreshElements()
		{
			if (lbxUndoblocks.SelectedItem != null)
			{
				referenceHandle1.EcoSpace = EcoSpace;
				int index = UndoService.UndoList.IndexOf(lbxUndoblocks.SelectedItem.ToString());
				IUndoBlock block = UndoService.UndoList[index];
				referenceHandle1.SetElement(block.GetChangedObjects());
			}
			else
				referenceHandle1.SetElement(null);
		}


		private void btnMoveSelectedUndoUp_Click(object sender, System.EventArgs e)
		{
			int currentIndex = lbxUndoblocks.SelectedIndex;
			UndoService.UndoList.MoveBlock(currentIndex, currentIndex-1);
			RefreshLists();
		}

		private void btnMoveSelectedUndoDown_Click(object sender, System.EventArgs e)
		{
			int currentIndex = lbxUndoblocks.SelectedIndex;
			UndoService.UndoList.MoveBlock(currentIndex, currentIndex+1);
			RefreshLists();
		}

		private void btnUndoSelected_Click(object sender, System.EventArgs e)
		{
			string selectedBlock = lbxUndoblocks.SelectedItem.ToString();
			UndoService.UndoBlock(selectedBlock);
			RefreshLists();
		}

		private void btnNamedCheckPoint_Click(object sender, System.EventArgs e)
		{
			string name=UndoService.GetUniqueBlockName(tbxUndoName.Text);
			UndoService.StartUndoBlock(name);
			RefreshLists();
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			object o = UndoService.UndoList[lbxUndoblocks.SelectedIndex];
		}

		private void btnClearEmpty_Click(object sender, System.EventArgs e)
		{
			for (int i = 0; i < UndoService.UndoList.Count; i++)
			{
				if (!UndoService.UndoList[i].ContainsChanges)
				{
					UndoService.UndoList.RemoveBlock(UndoService.UndoList[i].Name);
					i--;
				}
			}
			for (int i = 0; i < UndoService.RedoList.Count; i++)
			{
				if (!UndoService.RedoList[i].ContainsChanges)
				{
					UndoService.RedoList.RemoveBlock(UndoService.RedoList[i].Name);
					i--;
				}
			}
			RefreshLists();
		}
		
		private void button5_Click(object sender, System.EventArgs e)
		{
			UndoService.StartUndoBlock();
			RefreshLists();
		}
		
		private void btnRedoLatest_Click(object sender, System.EventArgs e)
		{
			UndoService.RedoLatest();
			RefreshLists();
		}

		private void btnUndoLatest_Click(object sender, System.EventArgs e)
		{
			UndoService.UndoLatest();
			RefreshLists();
		}

		private void btnStartTransaction_Click(object sender, System.EventArgs e)
		{
			UndoService.StartTransaction();
			RefreshLists();
		}

		private void btnCommitTransaction_Click(object sender, System.EventArgs e)
		{
			UndoService.CommitTransaction();
			RefreshLists();
		}

		private void btnRollbackTransaction_Click(object sender, System.EventArgs e)
		{
			try
			{
				UndoService.RollbackTransaction();
			}
			catch (Exception exception)
			{
				MessageBox.Show(exception.ToString());
			}
			RefreshLists();
		}

		private void lbxUndoblocks_DrawItem(object sender, System.Windows.Forms.DrawItemEventArgs e)
		{
			Font f = lbxUndoblocks.Font;
			string text = "";
			Brush b = Brushes.Black;
			if (e.Index >= 0  && e.Index < UndoService.UndoList.Count)
			{
				if (UndoService.UndoList[e.Index].ContainsChanges)
					f = new Font(lbxUndoblocks.Font, FontStyle.Bold);
				text = lbxUndoblocks.Items[e.Index].ToString();
			}
			if ((e.State & DrawItemState.Selected) == DrawItemState.Selected)
				b = Brushes.White;

			e.DrawBackground();
			e.Graphics.DrawString(text,	f, b, e.Bounds.X, e.Bounds.Y);

		}
		
		private void timer1_Tick(object sender, System.EventArgs e)
		{
			RefreshLists();
		}

		private void UndoDebuggerPanel_Activated(object sender, System.EventArgs e)
		{
			timer1.Enabled = true;
		}

		private void UndoDebuggerPanel_Deactivate(object sender, System.EventArgs e)
		{
			timer1.Enabled = false;
		}

	}
}
